#define _CRT_SECURE_NO_WARNINGS
#include <bits/stdc++.h>

using namespace std;

class Jarbol
{
private:

    long int x;
    long int y;
    long int i;

public:

    long int getX() { return x; }
    void setX(long int x) { this->x = x; }
    long int getY() { return y; }
    void setY(long int y) { this->y = y; }
    long int getI() { return i; }
    void setI(long int i) { this->i = i; }

    long int PresekDesno(long int y) { return this->x + this->y - y; }
    long int PresekLevo(long int y) { return this->x - this->y + y; }

    static long int NajbliziVisiLevo(vector <Jarbol>& jarboli, long int duzina, long int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        long int i = indeks-1;
        bool flagNadjen = false;

        for (; i > -1; i--)
        {
            if (jarboli[i].getY() > pocetni.getY())
            {
                flagNadjen = true;
                break;
            }
        }

        if (!flagNadjen) return -1;
        return pocetni.getX() - jarboli[i].PresekDesno(pocetni.getY());
    }

    static long int NajbliziVisiDesno(vector <Jarbol>& jarboli, long int duzina, long int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        long int i = indeks+1;
        bool flagNadjen = false;

        for (; i < duzina; i++)
        {
            if (jarboli[i].getY() > pocetni.getY())
            {
                flagNadjen = true;
                break;
            }
        }

        if (!flagNadjen) return -1;
        return jarboli[i].PresekLevo(pocetni.getY()) - pocetni.getX();

    }
};

int main()
{
    long int n;
    long int pom;
    

    scanf("%d", &n);

    vector <Jarbol> jarboli(n);

    for (long int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setX(pom);
        jarboli[i].setI(i);
    }

    for (long int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setY(pom);
    }

    sort(jarboli.begin(), jarboli.end(),
        [](Jarbol t1, Jarbol t2) { return t1.getX() < t2.getX(); 
        });

    vector <long int> output(n);

    long int najbliziVisiDesno = 0, najbliziVisiLevo = 0;

    for (long int i = 0; i < n; i++)
    {
        najbliziVisiDesno = Jarbol::NajbliziVisiDesno(jarboli, n, i);
        najbliziVisiLevo = Jarbol::NajbliziVisiLevo(jarboli, n, i);

        if (najbliziVisiDesno == -1 && najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = -1;
        else if (najbliziVisiDesno == -1)
            output[jarboli[i].getI()] = (najbliziVisiLevo);
        else if (najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = (najbliziVisiDesno);
        else
            output[jarboli[i].getI()] = (najbliziVisiDesno < najbliziVisiLevo ? najbliziVisiDesno : najbliziVisiLevo);
    }

    for (long int i = 0; i < n; i++) printf("%d\n", output[i]);

    return 0;
}